'use strict';

function StudentsModalCtrl($scope, $rootScope, UserResource, UserLogManager, GroupResults, GroupsManager){

    $scope.title = '';
    $scope.group = {};
    $scope.student = {};
    $scope.studentOriginal = {};
    $scope.defaults = {};
    $scope.existingStudent = {student_in_group: false};

    $scope.$on('Groups:openStudentModal', function(event, object){
        $scope.openModal();
        $scope.group = object.group;
        $scope.studentOriginal = object.student;
        $scope.defaults.repeat = '';
        $scope.student = angular.copy(object.student);
        $scope.title = ($scope.studentOriginal.id == 0) ? 'Dodaj uczestnika' : 'Edytuj uczestnika';
    });

    $scope.openModal = function(){
        angular.element('#modal-student-add').modal('show');
    }

    $scope.closeModal = function(){
        $scope.form.$setPristine();
        angular.element('#modal-student-add').modal('hide');
    }

    $scope.saveStudent = function(){
        if($scope.form.$valid)
        {
            $scope.studentOriginal.name = $scope.student.name;
            $scope.studentOriginal.surname = $scope.student.surname;
            $scope.studentOriginal.email = $scope.student.email;
            $scope.studentOriginal.group_id = $scope.group.id;

            $scope.group.checkUser($scope.studentOriginal, function(data){
                if(data.success.student_in_group === true)
                {
                    $scope.studentOriginal.hash = data.success.hash;
                    $scope.existingStudent = data.success;
                }
                else
                {
                    $scope.saveStudentFinal();
                }
            });
        }
    }

    $scope.saveStudentFinal = function()
    {
        var previousGroup = null;
        var studentKey = -1;
        angular.forEach(GroupsManager._groups, function(group){
            angular.forEach(group.users, function(user, key){
                if(user.email === $scope.studentOriginal.email)
                {
                    studentKey = key;
                    previousGroup = group;
                }
            });
        });
        if(previousGroup !== null)
        {
            var group = GroupsManager.findGroup(previousGroup.id);
            group.users.splice(studentKey, 1);
        }

        if($scope.studentOriginal.id == 0)
        {
            $scope.group.addUser($scope.studentOriginal);
        }
        else
        {
            $scope.studentOriginal.save();
        }
        UserLogManager._isLoadedData = false;
        GroupResults._isLoadedData = false;
        $scope.existingStudent = {student_in_group: false};

        $scope.closeModal();
    }

    $scope.validForm = function(form){
        if($scope.studentOriginal.id == 0)
        {
            return form.$dirty && (
                (form.email1.$dirty && (form.email1.$error.required || form.email1.$error.email))
                    || (form.email2.$dirty && (form.email2.$error.required || form.email2.$error.email || form.email2.$modelValue != form.email1.$modelValue))
                    || (form.name.$dirty && (form.name.$error.required || form.name.$error.minlength || form.name.$error.maxlength || form.name.$error.pattern))
                    || (form.surname.$dirty && (form.surname.$error.required || form.surname.$error.minlength || form.surname.$error.maxlength || form.surname.$error.pattern))
                );
        }
        else
        {

            return form.$dirty && (
                    (form.name.$dirty && (form.name.$error.required || form.name.$error.minlength || form.name.$error.maxlength || form.name.$error.pattern))
                    || (form.surname.$dirty && (form.surname.$error.required || form.surname.$error.minlength || form.surname.$error.maxlength || form.surname.$error.pattern))
                );
        }
    }
}

StudentsModalCtrl.$inject = ['$scope', '$rootScope', 'UserResource', 'UserLogManager', 'GroupResults', 'GroupsManager'];